import React, {Component} from 'react';
import PropTypes from 'prop-types';
import gql from 'graphql-tag';
import {graphql, compose} from "react-apollo";
import BlinkDot from "../Loading/BlinkDot";

class VehicleBreadcrumb extends Component {

    constructor(props) {
        super(props);
        console.log(props);
    }

    render() {
        const {data} = this.props;
        const {loading, vehicle} = data;

        if(loading) {
            return (<span className="text-info" style={{fontWeight: "normal", fontSize: "1.3rem"}}>Caricamento in corso <BlinkDot/><BlinkDot/><BlinkDot/></span>)
        }

        return (<span>{vehicle.radioCode}</span>);
    }
}

export default compose(
    graphql(gql`
        query($id: ID!) {
            vehicle(id: $id) {
                id
                radioCode
            }
        }
    `, {
        options:({id}) => {return{variables: {id: id}}},
    }),
)(VehicleBreadcrumb);

VehicleBreadcrumb.defaultProps = {};

VehicleBreadcrumb.propTypes = {};